/*
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *  
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 *  
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *  
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 * DEALINGS IN THE SOFTWARE.
 * 
 */

/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, indent: 4, forin: true, maxerr: 50, regexp: true */
/*global define, native */

// This is the JavaScript code for bridging to native functionality
// See dwbrackets_extentions for implementation of native methods.
var dwbrackets;
if (!dwbrackets) {
    dwbrackets = {};
}
(function () {

    /*
     * @private 
     */
    var _dummyCallback = function () {
    };


    /**
     * Dummy function to test the dwbrackets extension
     */
    native function Dummy();
    dwbrackets.dummy = function () {
        Dummy("hello");
    };

    native function EditorChanges();
    dwbrackets.editorChanges = function (filePath, changeList, selectionList, createNewUndo, callback) {
        EditorChanges(callback || _dummyCallback, filePath, changeList, selectionList, createNewUndo);
    }

    native function SelectionChanged();
    dwbrackets.selectionChanged = function (filePath, range, callback) {
        SelectionChanged(callback || _dummyCallback, filePath, range);
    }

    
    native function ActiveEditorChanged();
    dwbrackets.activeEditorChanged = function (curFilePath, prevFilePath, isInlineEditror, callback) {
        ActiveEditorChanged(callback || _dummyCallback, curFilePath, prevFilePath, isInlineEditror);
    }
	
    native function ShowIAMAfterActiveEditorChanged();
    dwbrackets.showIAMAfterActiveEditorChanged = function (curFilePath, callback) {
        ShowIAMAfterActiveEditorChanged(callback || _dummyCallback, curFilePath);
    }
 
    native function FocusChanged();
    dwbrackets.focusChanged = function (hasFocus, callback) {
        FocusChanged(callback || _dummyCallback, hasFocus);
    }
	
	native function PrintCodeReady();
    dwbrackets.printCodeReady = function (currentFilename, tempFileSuccess, callback) {
        PrintCodeReady(callback || _dummyCallback, currentFilename, tempFileSuccess);
    }

    native function GetCCLibAssetStatus();
    dwbrackets.getCCLibAssetStatus = function (assetPath, callback) {
        GetCCLibAssetStatus(callback || _dummyCallback, assetPath);
    }

    native function GetCCLibContextData();
    dwbrackets.getCCLibContextData = function (callback) {
        GetCCLibContextData(callback || _dummyCallback);
    }
    
    native function RebuildCCLibContextData();
    dwbrackets.rebuildCCLibContextData = function (callback) {
        RebuildCCLibContextData(callback || _dummyCallback);
    }
    
    native function ShowImageOptimizationPopUp();
    dwbrackets.showImageOptimizationPopUp = function (elementRef, top, left, callback) {
        ShowImageOptimizationPopUp(callback || _dummyCallback, elementRef, top, left);
    }

    native function ShowExtractPopUp();
    dwbrackets.showExtractPopUp = function (layerName, strId, top, left, callback) {
        ShowExtractPopUp(callback || _dummyCallback, layerName, strId, top, left);
    }
    
    native function GetComposedFilePath();
    dwbrackets.getComposedFilePath = function (filepath, callback) {
        GetComposedFilePath(callback || _dummyCallback, filepath);
    }

    
    native function GetSelCSSFromExtractPopupAsString();
    dwbrackets.getSelCSSFromExtractPopupAsString = function (callback) {
        GetSelCSSFromExtractPopupAsString(callback || _dummyCallback);
    }


	native function ShowDWColorPicker();
    dwbrackets.showDWColorPicker = function (selectedColor, top, left, isCodeHintInProgress, callback) {
        ShowDWColorPicker(callback || _dummyCallback, selectedColor, top, left, isCodeHintInProgress);
    }
	
	native function DismissDWColorPicker();
    dwbrackets.dismissDWColorPicker = function (shouldCommitColor, callback) {
        DismissDWColorPicker(callback || _dummyCallback, shouldCommitColor);
    }
 
    native function DWFindLaunchFindBar();
    dwbrackets.dwFindLaunchFindBar = function (initialQuery, callback) {
        DWFindLaunchFindBar(callback || _dummyCallback, initialQuery);
    }

    native function DWFindCloseFindBar();
    dwbrackets.dwFindCloseFindBar = function (callback) {
        DWFindCloseFindBar(callback || _dummyCallback);
    }

    native function DWFindShowError();
    dwbrackets.dwFindShowError = function (error, callback) {
        DWFindShowError(callback || _dummyCallback, error);
    }

    native function DWFindShowFindCount();
    dwbrackets.dwFindShowFindCount = function (count, callback) {
        DWFindShowFindCount(callback || _dummyCallback, count);
    }

    native function DWFindShowNoResults();
    dwbrackets.dwFindShowNoResults = function (showIndicator, showMessage, callback) {
        DWFindShowNoResults(callback || _dummyCallback, showIndicator, showMessage);
    }

    native function DWFindEnableControls();
    dwbrackets.dwFindEnableControls = function (enable, callback) {
        DWFindEnableControls(callback || _dummyCallback, enable);
    }

    native function DWFindFocusFindField();
    dwbrackets.dwFindFocusFindField = function (callback) {
        DWFindFocusFindField(callback || _dummyCallback);
    }

    native function DWFindEnableNavigation();
    dwbrackets.dwFindEnableNavigation = function (enable, callback) {
        DWFindEnableNavigation(callback || _dummyCallback, enable);
    }

    native function DWFindEnableReplace();
    dwbrackets.dwFindEnableReplace = function (enable, callback) {
        DWFindEnableReplace(callback || _dummyCallback, enable);
    }
	
    native function SynchronousCallComplete();
        dwbrackets.synchronousCallComplete = function () {
            SynchronousCallComplete();
     }

    native function GetKEHints();
        dwbrackets.getKEHints = function (requestStr, trigger, maxHintListSize, callback) {
            GetKEHints(callback || _dummyCallback, requestStr, trigger, maxHintListSize);
    }
	
	native function QuickEditUsed();
        dwbrackets.quickEditUsed = function (filePath) {
            QuickEditUsed(_dummyCallback, filePath);
     }
    
    native function QuickDocsUsed();
        dwbrackets.quickDocsUsed = function (filePath) {
            QuickDocsUsed(_dummyCallback, filePath);
     }
    
    native function QuickEditNewCSSRuleUsed();
        dwbrackets.quickEditNewCSSRuleUsed = function (filePath) {
            QuickEditNewCSSRuleUsed(_dummyCallback, filePath);
     }
    
    native function DwHeadlightLogging();
    dwbrackets.dwHeadlightLogging = function (category, subcategory, featureString) {
        DwHeadlightLogging(_dummyCallback, category, subcategory, featureString);
    }    

    native function CurrentFileLoaded();
    dwbrackets.currentFileLoadEnd = function (filePath) {
        CurrentFileLoaded(_dummyCallback,filePath);
	}

    native function GetKETips();
        dwbrackets.getKETips = function (requestStr, trigger, callback) {
            GetKETips(callback || _dummyCallback, requestStr, trigger);
    }
	
	native function SendLanguages();
    dwbrackets.sendLanguages = function (jsonStrOffileNames) {
        SendLanguages(_dummyCallback, jsonStrOffileNames);
	}
	
    native function SendCursorAndFileInfoToDw();
    dwbrackets.sendCursorAndFileInfoToDw = function (lineNo, colNo, lang, path, leftCoord, topCoord) {
        SendCursorAndFileInfoToDw(_dummyCallback, lineNo, colNo, lang, path, leftCoord, topCoord);
    }

    native function GetRelatedFilesForDoc();
    dwbrackets.getRelatedFilesForDoc = function(filePath, fileTypesArray, callback) {
        GetRelatedFilesForDoc(callback || _dummyCallback, filePath, fileTypesArray);
    }

    native function DoContextMenu();
    dwbrackets.doContextMenu = function (xCoord, yCoord, functionDetails, callback) {
        DoContextMenu(callback || _dummyCallback, xCoord, yCoord, functionDetails);
    }

    native function GetCSSSelectors();
    dwbrackets.getCSSSelectors = function (getIds, domInclusions, getAttrNames, callback) {
        GetCSSSelectors(callback || _dummyCallback, getIds, domInclusions, getAttrNames);
    }
    native function RefreshStyleList();
    dwbrackets.refreshStyleList = function (callback) {
        RefreshStyleList(callback || _dummyCallback);
    }   
    native function GetBrowsedFileURL();
    dwbrackets.getBrowsedFileURL = function (filePath, callback) {
        GetBrowsedFileURL(callback || _dummyCallback, filePath);
    }
    
    native function GetFontListHandler();
    dwbrackets.getFontList = function (callback) {
        GetFontListHandler(callback || _dummyCallback);
    }
    
    native function CacheBracketsHintList();
    dwbrackets.cacheBracketsHintList = function (list, callback) {
        CacheBracketsHintList(callback || _dummyCallback, list);
    }
    
    native function LaunchEditFontsDialog();
    dwbrackets.launchEditFontsDialog = function (callback) {
        LaunchEditFontsDialog(callback || _dummyCallback);
    }
    
    native function GetHintDescription();
    dwbrackets.getHintDescription = function (hintXPath, callback) {
        GetHintDescription(callback || _dummyCallback, hintXPath);
    }

    native function SetCodeFoldCache();
    dwbrackets.setCodeFoldCache = function (filePath, data) {
        SetCodeFoldCache(_dummyCallback, filePath, data);
    }

    native function GetCodeFoldCache();
    dwbrackets.getCodeFoldCache = function (filePath, callback) {
        GetCodeFoldCache(callback || _dummyCallback, filePath);
    }

    native function StoreLastAutomationOutput();
    dwbrackets.storeLastAutomationOutput = function (output, callback) {
        StoreLastAutomationOutput(callback || _dummyCallback, output);
    }
    
    native function GetTagLibCache();
    dwbrackets.getTagLibCache = function (callback) {
        GetTagLibCache(callback || _dummyCallback);
    }
    
    native function SignalSelectionSyncPending();
    dwbrackets.signalSelectionSyncPending = function (filePath, callback) {
        SignalSelectionSyncPending(callback || _dummyCallback, filePath);
    }

    native function GetCFMLTagLibCache();
    dwbrackets.getCfmlTagLibCache = function (callback) {
        GetCFMLTagLibCache(callback || _dummyCallback);
    }

    native function GetMimeTypeData();
    dwbrackets.getMimeType = function (filePath, callback) {
        GetMimeTypeData(callback || _dummyCallback, filePath);
    }
    
    native function GetSelectorsFromHTMLDOM();
    dwbrackets.getSelectorsFromHTMLDOM = function (getIds, callback) {
        GetSelectorsFromHTMLDOM(callback || _dummyCallback, getIds);
    }

	native function SetAllThemes();
        dwbrackets.setAllThemes = function (themes) {
            SetAllThemes(_dummyCallback, themes);
	}

    native function CodeFoldIconMidPoint();
        dwbrackets.codeFoldIconMidPoint = function (lineNo,xPoint,yPoint,foldIconPresent) {
            CodeFoldIconMidPoint(_dummyCallback, lineNo, xPoint, yPoint,foldIconPresent);
	}

    native function DWGitNotification();
    dwbrackets.dwGitNotification = function (notificationType, data, callback) {
        DWGitNotification(callback || _dummyCallback, notificationType, data);
    }
    
    native function CodeFoldLabelForLine();
        dwbrackets.codeFoldLabelForLine = function(lineNo, label) {
            CodeFoldLabelForLine(_dummyCallback, lineNo, label);
    }

    native function OnLinterResults();
    dwbrackets.sendLinterResultsToDw = function(docPath, results, err) {
        OnLinterResults(_dummyCallback, docPath, results, err);
    }

    native function CodeFoldTooltipForLine();
        dwbrackets.codeFoldTooltipForLine = function(lineNo, tooltip) {
            CodeFoldTooltipForLine(_dummyCallback, lineNo, tooltip);
    } 
})();
